#include "vars.h"
#include "moves.h"
#include "sfx.h"
#include "sounds.h"


void move_ball(BALL *p_ball) {
   int i, nb_sparks;
   
   p_ball->position.x += p_ball->speed.x;
   p_ball->position.y += p_ball->speed.y;
   
   
   //maintenant, on regarde si a ne tape pas sur le bord de l'cran

   //en hauteur
   if (p_ball->position.y - p_ball->bitmap->h/2 < 0  && p_ball->speed.y < 0) {
      p_ball->speed.y = -(p_ball->speed.y);
      ++current_score;
      play_sound(data_sfx[BORD_WAV].dat, p_ball->position.x);
      

      //Quelques tincelles! On en ajoute au hasard
      nb_sparks = rand() % (NB_MAX_SPARKS_RACKET/2) + NB_MAX_SPARKS_RACKET/2;
      for (i = 0; i < NB_MAX_SPARKS; ++i) {
         if (spark[i]. EXIST == FALSE) {
            add_random_spark(i, NULL, p_ball, SPARK_BORDER);
            --nb_sparks;
         }
         if (nb_sparks == 0)
            break;
      }
   }
   else if (p_ball->position.y + p_ball->bitmap->h/2 >= SCREEN_H  && p_ball->speed.y > 0) {
      p_ball->speed.y = -(p_ball->speed.y);
      ++current_score;      
      play_sound(data_sfx[BORD_WAV].dat, p_ball->position.x);
      //Quelques tincelles! On en ajoute au hasard
      nb_sparks = rand() % (NB_MAX_SPARKS_RACKET/2) + NB_MAX_SPARKS_RACKET/2;
      for (i = 0; i < NB_MAX_SPARKS; ++i) {
         if (spark[i]. EXIST == FALSE) {
            add_random_spark(i, NULL, p_ball, SPARK_BORDER);
            --nb_sparks;
         }
         if (nb_sparks == 0)
            break;
      }

   }
   //maintenant, si en largeur ca marche, c'est que c'est perdu pour le joueur cens la ratrapper!
  
   if (p_ball->position.x - p_ball->bitmap->w/2 >= SCREEN_W && p_ball->speed.x > 0) {
      --nb_current_balls;//le nombre de balles actuel
      p_ball->EXIST = FALSE;
      
      if (nb_current_balls <= 0) {//on dfinit qui a gagn!
         game_info.winning_side = LEFT;
         ++(game_info.nb_left_wins);
         if (player[0]->pos == LEFT)
            player[0]->score += current_score;
         if (player[1]->pos == LEFT)  //pas de else si jamais les deux sont du mme ct
            player[1]->score += current_score;
      }
      
      return; //on s'arrete l
   }
   if (p_ball->position.x + p_ball->bitmap->w/2 < 0  && p_ball->speed.x < 0) {
      --nb_current_balls;//le nombre de balles actuel
      p_ball->EXIST = FALSE;
      
      if (nb_current_balls <= 0) {//on dfinit qui a gagn!
         game_info.winning_side = RIGHT;
         ++(game_info.nb_right_wins);
         if (player[PLAYER_1]->pos == RIGHT)
            player[PLAYER_1]->score += current_score;
         if (player[PLAYER_2]->pos == RIGHT)  //pas de else si jamais les deux sont du mme ct
            player[PLAYER_2]->score += current_score;
      }
         
      return;  //pas la peine de continuer
   }
      
   
   //Nouveau systme : on parcourt la liste des joueurs et on effectue les tests de collision si ncssaire
   for (i = 0; i < nb_max_players; ++i) {
      if ((p_ball->next_side_to_hit == LEFT && player[i]->pos != LEFT) || (p_ball->next_side_to_hit == RIGHT && player[i]->pos != RIGHT))
         continue;

      if (detect_extrem_collision(p_ball, player[i]->racket, POSITION_TOP) == TRUE) {
         //il y a eu collision, il faut grer le pitch que donne la raquette sur la balle!
         gere_ball_racket_extrem_collision(p_ball, player[i]->racket, POSITION_TOP);
         current_score += 2; //on a tap sur une raquette -> on augmente le score de 2!
         if (p_ball->next_side_to_hit == LEFT)
            p_ball->next_side_to_hit = RIGHT;
         else
            p_ball->next_side_to_hit = LEFT;
      }
      else if (detect_extrem_collision(p_ball, player[i]->racket, POSITION_BOTTOM) == TRUE) {
         //il y a eu collision, il faut grer le pitch que donne la raquette sur la balle!
         gere_ball_racket_extrem_collision(p_ball, player[i]->racket, POSITION_BOTTOM);
         current_score += 2; //on a tap sur une raquette -> on augmente le score de 2!
         if (p_ball->next_side_to_hit == LEFT)
            p_ball->next_side_to_hit = RIGHT;
         else
            p_ball->next_side_to_hit = LEFT;
      }
      else if (detect_collision(p_ball->bitmap, p_ball->position.x-p_ball->bitmap->w/2, p_ball->position.y-p_ball->bitmap->h/2, player[i]->racket->main_bitmap, player[i]->racket->position.x - player[i]->racket->main_bitmap->w/2, player[i]->racket->position.y - player[i]->racket->main_bitmap->h/2)) {
         //il y a eu collision, il faut grer le pitch que donne la raquette sur la balle!
         gere_ball_racket_collision(p_ball, player[i]->racket);
         current_score++; //on a tap sur une raquette -> on augmente le score
         if (p_ball->next_side_to_hit == LEFT)
            p_ball->next_side_to_hit = RIGHT;
         else
            p_ball->next_side_to_hit = LEFT;
      }
      
      
   }   
   return;
}

void move_racket(RACKET *p_racket) {
   p_racket->position.x += p_racket->speed.x;//je le fais quand mme mais bon...:)
   p_racket->position.y += p_racket->speed.y;

   //on ne doit pas sortir de l'cran
   if (p_racket->position.y - p_racket->main_bitmap->h/2 - p_racket->top_bitmap->h < 0) {
      p_racket->position.y = p_racket->main_bitmap->h/2 + p_racket->top_bitmap->h;
      p_racket->speed.y = 0; //on la stoppe compltement
   }
   else if (p_racket->position.y + p_racket->main_bitmap->h/2 + p_racket->bottom_bitmap->h >= SCREEN_H) {
      p_racket->position.y = SCREEN_H - p_racket->main_bitmap->h/2 - p_racket->bottom_bitmap->h;
      p_racket->speed.y = 0; //on la stoppe compltement
   }

   if (p_racket-> IS_MOVING == FALSE) {
      if (p_racket->speed.y != 0) {
         if (p_racket->speed.y > 0) {
            p_racket->speed.y -= RACKET_DEC_Y;
            if (p_racket->speed.y < 0)
               p_racket->speed.y = 0;
         }
         else {
            p_racket->speed.y += RACKET_DEC_Y;
            if (p_racket->speed.y > 0)
               p_racket->speed.y = 0;
         }
      }
   }

   return;
}   
   


//Fonction trs importante: elle determine si il y a collision entre les bitmaps "bitmap1" et "bitmap2"
//les commentaires sont en anglais parce que je l'ai propose en tant que programme d'exemple avec allegro ;)
int detect_collision(BITMAP *bitmap1, int coorx_1, int coory_1, BITMAP *bitmap2, int coorx_2, int coory_2)
{
   int rect1_x, rect1_y; /* the coordinates of the rectangle of    */
   int rect2_x, rect2_y; /* overlap of the bitmaps' bounding boxes */

   int i, j, k, l;

   int mask1, mask2;

   /* We start by checking if the bitmaps' bounding boxes overlap. */
   /* In x: */
   if (coorx_1 + bitmap1->w <= coorx_2 || coorx_1 >= coorx_2 + bitmap2->w)
      return FALSE;
   /* In y: */
   if (coory_1 + bitmap1->h <= coory_2 || coory_1 >= coory_2 + bitmap2->h)
      return FALSE;
	return TRUE;
   /* Right, now that we know the bounding boxes overlap,
    * we need to determine the four corners of the overlap area.
    */

   /* We'll handle the x-coordinates first... */
   if (coorx_1 < coorx_2) {
      rect1_x = coorx_2;
      if (coorx_1 + bitmap1->w >= coorx_2 + bitmap2->w)
         rect2_x = coorx_2 + bitmap2->w;
      else 
         rect2_x = coorx_1 + bitmap1->w;
   }
   else {
      rect1_x = coorx_1;
      if (coorx_2 + bitmap2->w >= coorx_1 + bitmap1->w)
         rect2_x = coorx_1 + bitmap1->w;
      else 
         rect2_x = coorx_2 + bitmap2->w;
   }

   /* ...and now the y-coordinates. */
   if (coory_1 < coory_2) {
      rect1_y = coory_2;
      if (coory_1 + bitmap1->h >= coory_2 + bitmap2->h)
         rect2_y = coory_2 + bitmap2->h;
      else 
         rect2_y = coory_1 + bitmap1->h;
   }
   else {
      rect1_y = coory_1;
      if (coory_2 + bitmap2->h > coory_1 + bitmap1->h)
         rect2_y = coory_1 + bitmap1->h;
      else 
         rect2_y = coory_2 + bitmap2->h;
   }

   mask1 = bitmap_mask_color(bitmap1);
   mask2 = bitmap_mask_color(bitmap2);

   for (i = rect1_x - coorx_1, j = rect1_x - coorx_2; i < rect2_x - coorx_1; i++, j++) {
      for (k = rect1_y - coory_1, l = rect1_y - coory_2; k < rect2_y - coory_1; k++, l++) {
         if (getpixel(bitmap1, i, k) != mask1 && getpixel(bitmap2, j, l) != mask2)
            return TRUE;
      }
   }

   return FALSE;
}  

void gere_ball_racket_collision(BALL *p_ball, RACKET *p_racket) {
   int i, nb_sparks;
   
   //un petit son de collision?
   play_sound(data_sfx[RACKET01_WAV + rand() % NB_RACKET_SOUND].dat, p_racket->position.x);
      
  
   //Quelques tincelles! On en ajoute au hasard
   nb_sparks = rand() % (NB_MAX_SPARKS_RACKET/2) + NB_MAX_SPARKS_RACKET/2;
   for (i = 0; i < NB_MAX_SPARKS; ++i) {
      if (spark[i]. EXIST == FALSE) {
         add_random_spark(i, p_racket, p_ball, SPARK_RACKET);
         --nb_sparks;
      }
      if (nb_sparks == 0)
         break;
   }
  
   //si la raquette ne bouge pas, on se contente de renvoyer 
   p_ball->speed.x = -(p_ball->speed.x); //dj, on inverse la direction horizontale!   
   
   //voyons tout d'bord si les sens de dplacement verticaux sont identiques.
   if ((p_ball->speed.y < 0 && p_racket->speed.y < 0) || (p_ball->speed.y > 0 && p_racket->speed.y > 0)) {
      p_ball->speed.y += p_racket->speed.y;
      p_ball->speed.x *= 1.01; //on accelere quand mme la balle de 1%
   }
   else {
      p_ball->speed.y += p_racket->speed.y;
      p_ball->speed.x *= (1 + ABS(p_racket->speed.y*0.1)/ABS(p_ball->speed.x));
   }
   
   //limitation de la vitesse de la balle!
   if (game.cur_level->max_ball_speed.y != NOT_DEFINED) {
      if (p_ball->speed.y > game.cur_level->max_ball_speed.y)
         p_ball->speed.y = game.cur_level->max_ball_speed.y;
      else if (p_ball->speed.y < -game.cur_level->max_ball_speed.y)
         p_ball->speed.y = -game.cur_level->max_ball_speed.y;
   }
   if (game.cur_level->max_ball_speed.x != NOT_DEFINED) {
      if (p_ball->speed.x > game.cur_level->max_ball_speed.x)
         p_ball->speed.x = game.cur_level->max_ball_speed.x;
      else if (p_ball->speed.x < -game.cur_level->max_ball_speed.x)
         p_ball->speed.x = -game.cur_level->max_ball_speed.x;
   }
      
   return;
}

void add_random_spark(int index, RACKET* p_racket, BALL* p_ball, int source) {
   double speed, angle;
   
   spark[index].source = source;   
   spark[index].EXIST = TRUE;

   //NOMBRES MAGIQUES TEMPORAIRES POUR L'INSTANT
   speed = ((rand()%SPARK_SPEED_RAND)/SPARK_SPEED_DIVISOR_RAND + SPARK_SPEED_MIN_ADDED) * sqrt(sqrt(ball[0]->speed.x*ball[0]->speed.x + ball[0]->speed.y*ball[0]->speed.y));

   switch (source) {
      case SPARK_RACKET:

         if (p_racket->position.x > SCREEN_W/2) {
            if (p_racket->speed.y < 0) {
               angle = (rand()%SPARK_RACKET_RADIUS_ANGLE_RAND)/SPARK_RACKET_DIVISOR_ANGLE_RAND + PI/2.0;
            }
            else if (p_racket->speed.y > 0)
               angle = - ((rand()%SPARK_RACKET_RADIUS_ANGLE_RAND)/SPARK_RACKET_DIVISOR_ANGLE_RAND + PI/2.0);
            else 
               return;
               
            spark[index].pos.x = p_ball->position.x + p_ball->bitmap->w/2;
         }
         else if (p_racket->position.x < SCREEN_W/2) {
            if (p_racket->speed.y < 0)
               angle = PI/2 - (rand()%SPARK_RACKET_RADIUS_ANGLE_RAND)/SPARK_RACKET_DIVISOR_ANGLE_RAND;
            else if (p_racket->speed.y > 0)
               angle = - PI/2 + (rand()%SPARK_RACKET_RADIUS_ANGLE_RAND)/SPARK_RACKET_DIVISOR_ANGLE_RAND;
            else 
               return;
            
            spark[index].pos.x = p_ball->position.x - p_ball->bitmap->w/2;
         }
         else 
            return;
   

         spark[index].pos.y = p_ball->position.y;

   
         spark[index].speed.x = cos(angle)*speed;
         spark[index].speed.y = -sin(angle)*speed;  //LE MOINS VIENT DU FAIT QUE Y EST ORIENTE VERS LE HAUT ICI!!!!!
         spark[index].full_life = spark[index].life = rand()%(MAX_SPARK_LIFE/2) + MAX_SPARK_LIFE/2;
   
         spark[index].color = makecol(255,255,0);
         return;

      case SPARK_BORDER:
         if (p_ball->position.y < SCREEN_H/2) { //EN HAUT
            if (p_ball->speed.x < 0) 
               angle = (rand()%SPARK_BORDER_RADIUS_ANGLE_RAND)/SPARK_BORDER_DIVISOR_ANGLE_RAND + PI;        //en HAUT VERS LA DROITE
            else
               angle = - (rand()%SPARK_BORDER_RADIUS_ANGLE_RAND)/SPARK_BORDER_DIVISOR_ANGLE_RAND;
            spark[index].pos.y = 0;
         }
         else {                                 //EN BAS
            if (p_ball->speed.x < 0) 
               angle = PI - (rand()%SPARK_BORDER_RADIUS_ANGLE_RAND)/SPARK_BORDER_DIVISOR_ANGLE_RAND;
            else
               angle = (rand()%SPARK_BORDER_RADIUS_ANGLE_RAND)/SPARK_BORDER_DIVISOR_ANGLE_RAND;
            spark[index].pos.y = SCREEN_H - 1;
         }

         spark[index].pos.x = p_ball->position.x;

         spark[index].speed.x = cos(angle)*speed;
         spark[index].speed.y = -sin(angle)*speed;  //LE MOINS VIENT DU FAIT QUE Y EST ORIENTE VERS LE HAUT ICI!!!!!
         spark[index].full_life = spark[index].life = rand()%(MAX_SPARK_LIFE/2) + MAX_SPARK_LIFE/2;

         spark[index].color = makecol(255,255,255);
         return;

      default:
         break;
   }
   return;
}


void move_spark(SPARK* p_spark) {
   
   if (p_spark->EXIST == FALSE)
      return;
   
   p_spark->pos.x += p_spark->speed.x;
   p_spark->pos.y += p_spark->speed.y;
   
   --p_spark->life;
   
   switch (p_spark->source) {
      case SPARK_RACKET:
         p_spark->color = makecol(p_spark->life/p_spark->full_life * 255, p_spark->life/p_spark->full_life * 255, 0);
         break;
      case SPARK_BORDER:
         p_spark->color = makecol(p_spark->life/p_spark->full_life * 255, p_spark->life/p_spark->full_life * 255, p_spark->life/p_spark->full_life * 255);
         break;
      default:
         break;
   }      

   if (p_spark->pos.x < 0 || p_spark->pos.x >= SCREEN_W || p_spark->pos.y < 0 || p_spark->pos.y >= SCREEN_H || p_spark->life < 0)
      p_spark->EXIST = FALSE;

   return;
}


//Fonction qui detecte une collision entre le demi-disque et la balle
int detect_extrem_collision(BALL* b, RACKET* r, int position) {
   
 
   switch (position) {
      case POSITION_TOP:
         if (b->position.y > r->position.y - r->circle_centre_interval)
            return FALSE;
         if (distance(b->position.x, b->position.y, r->position.x, r->position.y - r->circle_centre_interval) < b->bitmap->w/2 + r->circle_radius)
            return TRUE;
         return FALSE;
      
      case POSITION_BOTTOM:
         if (b->position.y < r->position.y + r->circle_centre_interval)
            return FALSE;
         if (distance(b->position.x, b->position.y, r->position.x, r->position.y + r->circle_centre_interval) < b->bitmap->w/2 + r->circle_radius)
            return TRUE;
         return FALSE;

      default:
         break;
   }          
   return FALSE;   
}

double distance(double pos1_x, double pos1_y, double pos2_x, double pos2_y) {
   return sqrt((pos1_x-pos2_x)*(pos1_x-pos2_x) + (pos1_y-pos2_y)*(pos1_y-pos2_y));
}


//Cette fonction fait la mme chose que l'autre mais ici, on ajoute le case complexe de la collisiion entre deux cercles!
void gere_ball_racket_extrem_collision(BALL *b, RACKET *r, int position) {
   typedef struct {
      double norm;         //La norme du vecteur
      double angle;        //Son angle par rapport  l'axe des x orient de gauche  droite!   
   } VECTOR_POLAR;

   VECTOR_POLAR s_ball;    //la vitesse de la balle.
   VECTOR_POLAR p_centre;  //le vecteur position entre les deux centres.
   VECTOR_POLAR s_ball_f;  //la vitesse finale de la balle!
   
   double coeff_centres, coeff_norm;
   double angle_norm;
   int r_pos_y;
   
   if (position == POSITION_BOTTOM)
      r_pos_y = r->position.y + r->circle_centre_interval;
   else if (position == POSITION_TOP)
      r_pos_y = r->position.y - r->circle_centre_interval;
   else
      return;
   
   //Dj, il faut jouer un son. Ici, on peut jouer un son un peu modifi puisqu'on a tap sur le bout de la raquette
   //un petit son de collision?
   play_sound(data_sfx[RACKETEX_WAV].dat, r->position.x);

   
   //on calcules les deux vecteurs dj connus en fait.
   //ATTENTION, Y EST ORIENTE VERS LE BAS!!!!! -> les pos en Y sont  inverser!!
   p_centre.angle = atan2(-(b->position.y - r_pos_y), b->position.x - r->position.x); //AXE Y INVERS
   p_centre.norm = distance(b->position.x, b->position.y, r->position.x, r_pos_y);
   
   s_ball.angle = atan2(-b->speed.y, b->speed.x);//AXE Y INVERS
   s_ball.norm = distance (0,0,b->speed.x, b->speed.y);

   //Bah, on pourrait rduire toutes ces lignes en une mais je vais les laisser pour qu'on y comprenne quelque chose...

   //on trouve le coeff de la pente de la droite des centres:
   coeff_centres = -(r_pos_y - b->position.y)/(r->position.x - b->position.x);
   //d'o le coefficient normal:
   coeff_norm = -1/coeff_centres;
   angle_norm = atan2(coeff_norm, 1);
   
   //maintenant, on sait que cet angle est l'angle moiti de l'angle entre les deux vecteurs vitesse (intial et final).
   s_ball_f.angle = fmod(2*angle_norm - s_ball.angle, 2*PI);

   s_ball_f.norm = s_ball.norm;
   
   //Dans le log pour vrif:
   //fprintf(fp, "T:%d, Pos = %.2f - Sball = %.2f | SRes = %.2f || Coeff pos=%.2f, coeff norm=%.2f\n", current_sec_counter, RAD_TO_DEGREE(p_centre.angle), RAD_TO_DEGREE(s_ball.angle), RAD_TO_DEGREE(s_ball_f.angle), coeff_centres, coeff_norm);


   //Maintenant, on convertit de polaires -> cartsiennes!
   b->speed.x = cos(s_ball_f.angle)*s_ball_f.norm;
   b->speed.y = -(sin(s_ball_f.angle)*s_ball_f.norm);     //AXE Y INVERS

   //on rajoute  la vitesse verticale celle de la raquette!
   b->speed.y += r->speed.y;

   
   //limitation de la vitesse de la balle!
   if (game.cur_level->max_ball_speed.y != NOT_DEFINED) {
      if (b->speed.y > game.cur_level->max_ball_speed.y)
         b->speed.y = game.cur_level->max_ball_speed.y;
      else if (b->speed.y < -game.cur_level->max_ball_speed.y)
         b->speed.y = -game.cur_level->max_ball_speed.y;
   }
   if (game.cur_level->max_ball_speed.x != NOT_DEFINED) {
      if (b->speed.x > game.cur_level->max_ball_speed.x)
         b->speed.x = game.cur_level->max_ball_speed.x;
      else if (b->speed.x < -game.cur_level->max_ball_speed.x)
         b->speed.x = -game.cur_level->max_ball_speed.x;
   }
   
   

   return;
}
   
